﻿using System;
using System.Reflection;
using Microsoft.Win32;
using System.Security;
using System.Security.Permissions;
using System.Security.AccessControl;
using System.IO;
using System.Security.Principal;
using System.Drawing;

namespace TwoCamWPF.Helpers
{
	class SerialPortBaudRates
	{
		public static int[] values = { 110, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 56000, 57600, 115200, 128000, 256000 };
	}

	class NoWebcamException : Exception
	{
	}

	class WebcamPropertiesException : Exception
	{
	}

	class VideoStartException : Exception
	{
	}

	
	enum RecordingState
	{
		Stopped,
		Started
	}

	static class DirectoryWriteChecker
	{
		public static bool Process(string dir)
		{
			string filename = dir + "\\test.avi";
            	try
			{
                if (!Directory.Exists(dir))
                Directory.CreateDirectory(dir);
		
				using (FileStream fs = File.Create(filename))
				{
					fs.Close();
					File.Delete(filename);
				}
			}
			catch
			{
				return false;
			}

			return true;
		}
	}

	class AutorunHelper
	{
		private static readonly string AUTORUN_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";

		static void SetEnabled(bool enabled)
		{
			if (enabled)
				EnableAutorun();
			else
				DisableAutorun();
		}

        static bool GetEnabled()
        {
            RegistryKey key = Registry.CurrentUser;
            string CarDvr = Assembly.GetExecutingAssembly().GetName().Name;

            try
            {
                key = Registry.CurrentUser.OpenSubKey(AUTORUN_KEY, false);
                object o = key.GetValue(CarDvr);
                if ( o == null) return false;
            }
            catch
            {
                return false;
            }

            return true;
        }

        public static bool Enabled
        {
            set
            {
                SetEnabled(value);
            }

            get
            {
                return GetEnabled();
            }
        }

		public static void EnableAutorun()
		{
			Assembly asm = Assembly.GetExecutingAssembly();

			string exepath = asm.Location;
			string CarDrv = asm.GetName().Name;

			RegistryKey key = Registry.CurrentUser;
			try
			{
				key = Registry.CurrentUser.OpenSubKey(AUTORUN_KEY, true);
				key.SetValue(CarDrv, exepath, RegistryValueKind.String);
			}
			catch
			{
                //Program.settings.StartWithWindows = false;
                //Program.settings.Save();
			}

			key.Close();
		}

		public static void DisableAutorun()
		{
			RegistryKey key = Registry.CurrentUser;
			string CarDvr = Assembly.GetExecutingAssembly().GetName().Name;

			try
			{
				key = Registry.CurrentUser.OpenSubKey(AUTORUN_KEY, true);
				key.DeleteValue(CarDvr);
			}
			catch
			{
                //Program.settings.StartWithWindows = false;
                //Program.settings.Save();
			}

			key.Close();
		}


	}

  
}
